# from al.Utils import *
# from al.Workspace import Workspace
# from al.generated.GeneratedClasses import *

from anylogic_design_time_api import *
from anylogic_design_time_api.generated import *

# Set up connection & connect to model
ws = Workspace('092d612e-ebfd-4115-83e3-f2fc085f90f4')
modelName = 'py_model'
model = ws.getModel(modelName)
agent = model.getAgent('Main')
level = agent.getLevels()[0]

# Create railroads
rSwitch = RailroadSwitch.create(level)
r1 = RailTrack.create(level)
r2 = RailTrack.create(level)
r3 = RailTrack.create(level)

# Layout
rSwitch.setX(75)
r2.setX(75)
r3.setX(75)
r3.setY(75)

r1Points = [0.0, 0.0, 0.0, 75.0, 0.0, 0.0]
r1PointList = Utils.createStraightPointsList(r1, r1Points)
r1.setPointList(r1PointList)

r2Points = [0.0, 0.0, 0.0, 150.0, 0.0, 0.0]
r2PointList = Utils.createStraightPointsList(r2, r2Points)
r2.setPointList(r2PointList)

r3Points = [0.0, 0.0, 0.0, 0.0, -75.0, 0.0]
r3PointList = Utils.createStraightPointsList(r3, r3Points)
r3.setPointList(r3PointList)

# Network
r1.setTarget(rSwitch)
r2.setSource(rSwitch)
r3.setTarget(rSwitch)